import React, { useMemo } from 'react';
import "./firesideCabinTheme.css";

interface FiresideCabinThemeProps {
  mode?: "light" | "dusky"; // 'dusky' for deep winter's night feel
}

const FiresideCabinTheme: React.FC<FiresideCabinThemeProps> = ({ mode = "light" }) => {
  const headerImages = useMemo(() => [
    "/images/Elements/cafeheader.png"
  ], []);

  const backgroundBorderImages = useMemo(() => [
    "/images/RoyaltyFree/warm mahogany cowhide.jpg",
    "/images/RoyaltyFree/rustic leather.avif",
    "/images/RoyaltyFree/warm wood.avif",
    "/images/RoyaltyFree/forest clouds 6.jpg" // For a wintery outdoor border
  ], []);

  const mainBackgroundImageHints = useMemo(() => [
    "/images/Elements/cafebackground.png"
  ], []);

  const sidebarImages = useMemo(() => [
    "/images/Elements/cafesidebar.png"
  ], []);

  const frameDecorationImages = useMemo(() => [
    "/images/Elements/cabinframe1.png",
    "/images/Elements/cabinframe2.png",
    "/images/Elements/cabinframe3.png",
    "/images/Elements/cabinframe4.png"
  ], []);

  const selectedHeaderImage = useMemo(() => headerImages[0], [headerImages]);
  const selectedBackgroundBorderImage = useMemo(() => backgroundBorderImages[Math.floor(Math.random() * backgroundBorderImages.length)], [backgroundBorderImages]);
  const selectedMainBackgroundImageHint = useMemo(() => mainBackgroundImageHints[0], [mainBackgroundImageHints]);
  const selectedSidebarImage = useMemo(() => sidebarImages[0], [sidebarImages]);
  const selectedFrameDecorationImage = useMemo(() => frameDecorationImages[Math.floor(Math.random() * frameDecorationImages.length)], [frameDecorationImages]);
  const selectedFrameFullBorderImage = useMemo(() => frameDecorationImages[Math.floor(Math.random() * frameDecorationImages.length)], [frameDecorationImages]);

  const navItems = [
    { name: "Hearth A", path: "/annepie/hearthA" },
    { name: "Hearth B", path: "/annepie/hearthB" },
    { name: "Hearth C", path: "/annepie/hearthC" },
    { name: "Hearth D", path: "/annepie/hearthD" },
    { name: "Hearth E", path: "/annepie/hearthE" },
  ];

  return (
    <div
      className={`cabin-theme-container ${mode}`}
      style={{ backgroundImage: `url(${selectedMainBackgroundImageHint})` }}
    >
      <header className="cabin-header">
        <img src={selectedHeaderImage} alt="Cabin Header" className="cabin-header-image" />
        <div className="cabin-header-overlay">
          <h1 className="cabin-site-title">Annepi.com</h1>
          <nav className="cabin-navigation">
            {navItems.map(item => (
              <a key={item.name} href={item.path} className="cabin-nav-link">{item.name}</a>
            ))}
          </nav>
        </div>
      </header>

      <div 
        className="cabin-body-wrapper"
        style={{ backgroundImage: `url(${selectedBackgroundBorderImage})` }}
      >
        <div className="cabin-content">
          <aside
            className="cabin-sidebar"
            style={{ backgroundImage: `url(${selectedSidebarImage})` }}
          >
            <p><strong>Fireside Thoughts:</strong></p>
            <ul className="cabin-sidebar-path">
              <li><a href="#hearth">By the Hearth</a></li>
              <li><a href="#cozy">Cozy Corner</a></li>
              <li><a href="#warmth">Winter Warmth</a></li>
            </ul>
            <p>The fire crackles softly...</p>
          </aside>

          <main className="cabin-main">
            <h2>Mountain Retreat</h2>
            <p>A cozy escape into warmth and comfort.</p>

            <div className="cabin-decorative-frame cabin-video-frame-example">
              <div className="cabin-frame-decoration-top" style={{backgroundImage: `url(${selectedFrameDecorationImage})`}}></div>
              <div className="cabin-frame-content">
                <p>Content with rustic top/bottom frame</p>
              </div>
              <div className="cabin-frame-decoration-bottom" style={{backgroundImage: `url(${selectedFrameDecorationImage})`}}></div>
            </div>

            <div 
              className="cabin-decorative-frame cabin-full-border-frame-example"
              style={{ backgroundImage: `url(${selectedFrameFullBorderImage})` }}
            >
              <div className="cabin-frame-content">
                <p>Stories by the firelight</p>
              </div>
            </div>

            <div className="cabin-decorative-frame cabin-circular-frame-example">
                <div className="cabin-frame-content cabin-circular-content">
                    <p>Ember</p>
                </div>
            </div>
          </main>
        </div>
      </div>
    </div>
  );
};

export default FiresideCabinTheme; 